@echo off
color fc

rem Change the following if required for your installation
set CW_HOME=C:\Program Files (x86)\Freescale
if not exist "%CW_HOME%" set CW_HOME=C:\Program Files\Freescale
cls
echo. 
echo ********************************************************** 
echo This script should be run as Administrator under Vista
echo (Right-click and select "Runs as administrator")
echo ********************************************************** 
echo.
echo This script will modify your Codewarrior installation(s)!
echo.
echo It assumes Codewarrior has been installed to the default location:
echo.
echo %CW_HOME% 
echo.
echo Modify if necessary
echo.
echo You should check the contents of this file before continuing.
echo.
echo Press CTRL-C to abort or any other key to continue.
echo.
pause
cls

set HOME_DIR=%~dp0

set SOURCE_DIR=%HOME_DIR%Release_DLLs
if exist "%SOURCE_DIR%" goto okSourceDirectory
cls
echo.
echo.
echo ***************************************************
echo *                     ERROR                       *     
echo *                                                 *     
echo *   Installation files not found:                 *
echo *                                                 *     
echo *   Please UNZIP Release_DLLs.zip and try again   *
echo *                                                 *     
echo *   Installation failed.                          *
echo *                                                 *     
echo ***************************************************
echo.
echo.
goto finish
:okSourceDirectory

set UTILITIES_DIR=%HOME_DIR%Utilities
if exist "%UTILITIES_DIR%" goto okUtilitiesDirectory
cls
echo.
echo.
echo ***************************************************
echo *                     ERROR                       *     
echo *                                                 *     
echo *   Installation files not found:                 *
echo *                                                 *     
echo *   Please UNZIP Utilities.zip and try again      *
echo *                                                 *     
echo *   Installation failed.                          *
echo *                                                 *     
echo ***************************************************
echo.
echo.
goto finish
:okUtilitiesDirectory

if exist "%CW_HOME%" goto okParentDirectory
cls
echo.
echo.
echo ***************************************************
echo *                     ERROR                       *     
echo *                                                 *     
echo *   Codewarrior directory not found:              *
echo *                                                 *     
echo *   "%CW_HOME%"
echo *                                                 *     
echo *   Installation failed.                          *
echo *                                                 *     
echo ***************************************************
echo.
echo.
goto finish
:okParentDirectory

rem Change the following if required for your installation
set CW_HCS12_DIR=%CW_HOME%\CWS12v5.1
set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.3
set CW_CFVx_DIR=%CW_HOME%\CodeWarrior for ColdFire V7.2
set CW_DSC_DIR=%CW_HOME%\CodeWarrior for DSC56800E v8.3

rem set NOICE_DIR=C:\Program Files\NoICE

rem echo Copying files from %SOURCE_DIR%
rem echo.

rem This tries to locate the Codewarrior directories if the above are not found
rem --------------------------------------------------------------------------------
set CW_ECLIPSE_DIR=%CW_HOME%\CW MCU v10.1
set ECLIPSE_VER=10_1
if exist "%CW_ECLIPSE_DIR%" goto EclipseFound
set CW_ECLIPSE_DIR=%CW_HOME%\CW MCU v10.0
set ECLIPSE_VER=10_0
if exist "%CW_ECLIPSE_DIR%" goto EclipseFound

:EclipseFound
echo Found Codewarrior Eclipse V_%ECLIPSE_VER%, DIR=%CW_ECLIPSE_DIR%
echo.
if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\CWS12v5.1
if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\CodeWarrior for S12(X) V5.0
if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\Codewarrior for HCS12 V4.7
if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\Codewarrior for HCS12 V4.6
if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\Codewarrior for HCS12 V4.5

if not exist "%CW_HCS08_DIR%" set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.3
if not exist "%CW_HCS08_DIR%" set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.2
if not exist "%CW_HCS08_DIR%" set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.1
if not exist "%CW_HCS08_DIR%" set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.0

if not exist "%CW_CFVx_DIR%"  set CW_CFVx_DIR=%CW_HOME%\CodeWarrior for ColdFire V7.1
if not exist "%CW_CFVx_DIR%"  set CW_CFVx_DIR=%CW_HOME%\CodeWarrior for ColdFire V7.0

if not exist "%CW_DSC_DIR%" set CW_DSC_DIR=%CW_HOME%\CodeWarrior for DSC56800E v8.3


rem ========================================================================
rem ========================================================================
rem ========================================================================
rem ========================================================================

set ECLIPSE_PLUGIN=%CW_ECLIPSE_DIR%\eclipse\plugins
set ECLIPSE_LAUNCH_DIR="%CW_ECLIPSE_DIR%\MCU\lib\wizard_data\launch_config
echo "Installing USBDM Wizard for Codewarrior for MCU (Eclipse)"
echo ===========================================================
set WIZARD_PATCH_FILE=%UTILITIES_DIR%\Patch_%ECLIPSE_VER%.xml
set WIZARD_DONE=""
rem Patch each wizard folder
for /D %%f in ("%ECLIPSE_PLUGIN%\com.freescale.mcu.projectwizard_1.3.*") do call :doWizard %%f
goto completeEclipse

rem =======================================================
:doWizard
set WIZARD_FILE_DIR=%*
set WIZARD_FILE="%WIZARD_FILE_DIR%\plugin.xml"
echo WIZARD_FILE=%WIZARD_FILE%
if exist %WIZARD_FILE% goto WizardFound
echo "Wizard file not found"
goto :EOF

:WizardFound
if exist %WIZARD_FILE%.original goto skippedMakeBackup
echo Backing up existing plugin file
copy %WIZARD_FILE% %WIZARD_FILE%.original
:skippedMakeBackup
rem echo "%UTILITIES_DIR%\mergeXml.exe" %WIZARD_FILE%.original %WIZARD_FILE% %WIZARD_PATCH_FILE%
"%UTILITIES_DIR%\mergeXml.exe" %WIZARD_FILE%.original %WIZARD_FILE% "%WIZARD_PATCH_FILE%"
set WIZARD_DONE=TRUE
goto :EOF

rem =======================================================
:completeEclipse
if not '%WIZARD_DONE%'=='TRUE' goto skippedCW_ECLIPSE
copy "%UTILITIES_DIR%\CW_%ECLIPSE_VER%\*.xml" %ECLIPSE_LAUNCH_DIR%
echo Re-initialising eclipse ... Please wait ...
"%CW_ECLIPSE_DIR%\eclipse\cwide" -clean -initialize
echo Done
echo.
:skippedCW_ECLIPSE

rem ========================================================================
rem ========================================================================
rem ========================================================================
rem ========================================================================
rem CodeWarrior for Microcontrollers
if not exist "%CW_HCS08_DIR%" goto skippedHCS08
echo "Modifying Wizard files for Codewarrior for RS08/HCS08/Coldfire V1"
echo =======================================================================
set WIZARD_DIR="%CW_HCS08_DIR%\bin\plugins\Support\HC(S)08Wizard"
pushd %WIZARD_DIR%
if exist XML.original goto dontBackupHC08Wizard
mkdir XML.original
copy XML XML.original
:dontBackupHC08Wizard
echo Patching XML Wizard files
cd XML.original
for %%f in (HCS908*.xml)  do "%UTILITIES_DIR%\mergeXML" "%%f" "..\XML\%%f" "%UTILITIES_DIR%\OSBDM_HCS08_Wizard_V6_3.xml"
for %%f in (SC9S08*.xml)  do "%UTILITIES_DIR%\mergeXML" "%%f" "..\XML\%%f" "%UTILITIES_DIR%\OSBDM_HCS08_Wizard_V6_3.xml"
for %%f in (MCF51*.xml)   do "%UTILITIES_DIR%\mergeXML" "%%f" "..\XML\%%f" "%UTILITIES_DIR%\OSBDM_MCF51_Wizard_V6_3.xml"
popd
echo.
:skippedHCS08

rem ====================================================================================================
rem Codewarrior for HCS12
if not exist "%CW_HCS12_DIR%" goto skippedHCS12
echo "Modifying Wizard files for Codewarrior for HCS12"
echo ======================================================
set WIZARD_DIR="%CW_HCS12_DIR%\bin\Plugins\Support\HC12Wizard"
pushd %WIZARD_DIR%
if exist XML.original goto dontBackupHC12Wizard
mkdir XML.original
copy XML XML.original
:dontBackupHC12Wizard
echo Patching XML Wizard files
cd XML.original
for %%f in (MC9S12x*.xml) do "%UTILITIES_DIR%\mergeXML" "%%f" "..\XML\%%f" "%UTILITIES_DIR%\TBDML_HCS12x_Wizard_5_1.xml"
popd
echo.
:skippedHCS12


rem ====================================================================================================
:finish
echo.
echo.
pause